/*
 * Decompiled with CFR 0.152.
 */
package com.concurrent_ruby.ext;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class JavaAtomicBooleanLibrary
implements Library {
    private static final ObjectAllocator JRUBYREFERENCE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new JavaAtomicBoolean(ruby, rubyClass);
        }
    };

    public void load(Ruby ruby, boolean bl) throws IOException {
        RubyModule rubyModule = ruby.defineModule("Concurrent");
        RubyClass rubyClass = rubyModule.defineClassUnder("JavaAtomicBoolean", ruby.getObject(), JRUBYREFERENCE_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(JavaAtomicBoolean.class);
    }

    @JRubyClass(name={"JavaAtomicBoolean"}, parent="Object")
    public static class JavaAtomicBoolean
    extends RubyObject {
        private AtomicBoolean atomicBoolean;

        public JavaAtomicBoolean(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) {
            this.atomicBoolean = new AtomicBoolean(this.convertRubyBooleanToJavaBoolean(iRubyObject));
            return threadContext.nil;
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext threadContext) {
            this.atomicBoolean = new AtomicBoolean();
            return threadContext.nil;
        }

        @JRubyMethod(name={"value"})
        public IRubyObject value() {
            return this.getRuntime().newBoolean(this.atomicBoolean.get());
        }

        @JRubyMethod(name={"true?"})
        public IRubyObject isAtomicTrue() {
            return this.getRuntime().newBoolean(this.atomicBoolean.get());
        }

        @JRubyMethod(name={"false?"})
        public IRubyObject isAtomicFalse() {
            return this.getRuntime().newBoolean(!this.atomicBoolean.get());
        }

        @JRubyMethod(name={"value="})
        public IRubyObject setAtomic(ThreadContext threadContext, IRubyObject iRubyObject) {
            this.atomicBoolean.set(this.convertRubyBooleanToJavaBoolean(iRubyObject));
            return threadContext.nil;
        }

        @JRubyMethod(name={"make_true"})
        public IRubyObject makeTrue() {
            return this.getRuntime().newBoolean(this.atomicBoolean.compareAndSet(false, true));
        }

        @JRubyMethod(name={"make_false"})
        public IRubyObject makeFalse() {
            return this.getRuntime().newBoolean(this.atomicBoolean.compareAndSet(true, false));
        }

        private boolean convertRubyBooleanToJavaBoolean(IRubyObject iRubyObject) {
            return !(iRubyObject instanceof RubyBoolean.False) && !(iRubyObject instanceof RubyNil);
        }
    }
}

